/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBaseException;
import org.python.core.PyClass;
import org.python.core.PyFile;
import org.python.core.PyFrame;
import org.python.core.PyInstance;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTraceback;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.core.__builtin__;

public class PyException
extends RuntimeException {
    public PyObject type;
    public PyObject value = Py.None;
    public PyTraceback traceback;
    private boolean isReRaise = false;
    private boolean normalized = false;
    private boolean printingStackTrace = false;

    public PyException() {
        this(Py.None, Py.None);
    }

    public PyException(PyObject pyObject) {
        this(pyObject, Py.None);
    }

    public PyException(PyObject pyObject, PyObject pyObject2) {
        this(pyObject, pyObject2, null);
    }

    public PyException(PyObject pyObject, PyObject pyObject2, PyTraceback pyTraceback) {
        this.type = pyObject;
        this.value = pyObject2;
        if (pyTraceback != null) {
            this.traceback = pyTraceback;
            this.isReRaise = true;
        } else {
            PyFrame pyFrame = Py.getFrame();
            if (pyFrame != null && pyFrame.tracefunc != null) {
                pyFrame.tracefunc = pyFrame.tracefunc.traceException(pyFrame, this);
            }
        }
    }

    public PyException(PyObject pyObject, String string) {
        this(pyObject, new PyString(string));
    }

    public void printStackTrace() {
        Py.printException(this);
    }

    public Throwable fillInStackTrace() {
        return Options.includeJavaStackInExceptions ? super.fillInStackTrace() : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void printStackTrace(PrintStream printStream) {
        if (this.printingStackTrace) {
            super.printStackTrace(printStream);
        } else {
            try {
                this.printingStackTrace = true;
                Py.displayException(this.type, this.value, this.traceback, new PyFile(printStream));
            }
            finally {
                this.printingStackTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void super__printStackTrace(PrintWriter printWriter) {
        try {
            this.printingStackTrace = true;
            super.printStackTrace(printWriter);
        }
        finally {
            this.printingStackTrace = false;
        }
    }

    public synchronized String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (!this.printingStackTrace) {
            this.printStackTrace(new PrintStream(byteArrayOutputStream));
        }
        return byteArrayOutputStream.toString();
    }

    public void normalize() {
        if (this.normalized) {
            return;
        }
        PyObject pyObject = null;
        if (PyException.isExceptionInstance(this.value)) {
            pyObject = this.value.fastGetClass();
        }
        if (PyException.isExceptionClass(this.type)) {
            if (pyObject == null || !Py.isSubClass(pyObject, this.type)) {
                PyObject[] pyObjectArray = this.value == Py.None ? Py.EmptyObjects : (this.value instanceof PyTuple && this.type != Py.KeyError ? ((PyTuple)this.value).getArray() : new PyObject[]{this.value});
                this.value = this.type.__call__(pyObjectArray);
            } else if (pyObject != this.type) {
                this.type = pyObject;
            }
        }
        this.normalized = true;
    }

    public void tracebackHere(PyFrame pyFrame) {
        this.tracebackHere(pyFrame, false);
    }

    public void tracebackHere(PyFrame pyFrame, boolean bl) {
        if (!this.isReRaise && pyFrame != null) {
            this.traceback = new PyTraceback(this.traceback, pyFrame);
        }
        this.isReRaise = bl;
    }

    public static PyException doRaise(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        Object object;
        if (pyObject == null) {
            object = Py.getThreadState();
            pyObject = ((ThreadState)object).exception.type;
            pyObject2 = ((ThreadState)object).exception.value;
            pyObject3 = ((ThreadState)object).exception.traceback;
        }
        if (pyObject3 == Py.None) {
            pyObject3 = null;
        } else if (pyObject3 != null && !(pyObject3 instanceof PyTraceback)) {
            throw Py.TypeError("raise: arg 3 must be a traceback or None");
        }
        if (pyObject2 == null) {
            pyObject2 = Py.None;
        }
        while (pyObject instanceof PyTuple && ((PyTuple)pyObject).size() > 0) {
            pyObject = pyObject.__getitem__(0);
        }
        if (pyObject.getType() == PyString.TYPE) {
            Py.warning(Py.DeprecationWarning, "raising a string exception is deprecated");
        } else {
            if (PyException.isExceptionClass(pyObject)) {
                object = new PyException(pyObject, pyObject2, (PyTraceback)pyObject3);
                ((PyException)object).normalize();
                return object;
            }
            if (PyException.isExceptionInstance(pyObject)) {
                if (pyObject2 != Py.None) {
                    throw Py.TypeError("instance exception may not have a separate value");
                }
                pyObject2 = pyObject;
                pyObject = pyObject.fastGetClass();
            } else {
                throw Py.TypeError("exceptions must be classes, instances, or strings (deprecated), not " + pyObject.getType().fastGetName());
            }
        }
        return new PyException(pyObject, pyObject2, (PyTraceback)pyObject3);
    }

    public boolean match(PyObject pyObject) {
        if (pyObject instanceof PyTuple) {
            for (PyObject pyObject2 : ((PyTuple)pyObject).getArray()) {
                if (!this.match(pyObject2)) continue;
                return true;
            }
            return false;
        }
        this.normalize();
        if (pyObject == Py.IOError && __builtin__.isinstance(this.value, PyType.fromClass(IOException.class))) {
            return true;
        }
        if (pyObject == Py.MemoryError && __builtin__.isinstance(this.value, PyType.fromClass(OutOfMemoryError.class))) {
            return true;
        }
        if (PyException.isExceptionClass(this.type) && PyException.isExceptionClass(pyObject)) {
            return Py.isSubClass(this.type, pyObject);
        }
        return this.type == pyObject;
    }

    public static boolean isExceptionClass(PyObject pyObject) {
        if (pyObject instanceof PyClass) {
            return true;
        }
        if (!(pyObject instanceof PyType)) {
            return false;
        }
        PyType pyType = (PyType)pyObject;
        if (pyType.isSubType(PyBaseException.TYPE)) {
            return true;
        }
        return pyType.getProxyType() != null && Throwable.class.isAssignableFrom(pyType.getProxyType());
    }

    public static boolean isExceptionInstance(PyObject pyObject) {
        return pyObject instanceof PyInstance || pyObject instanceof PyBaseException || pyObject.getJavaProxy() instanceof Throwable;
    }

    public static String exceptionClassName(PyObject pyObject) {
        return pyObject instanceof PyClass ? ((PyClass)pyObject).__name__ : ((PyType)pyObject).fastGetName();
    }
}

